#!/usr/bin/env python3
#vp_slider_zylinder.py
from vpython import *
#Daten
l0=3
d0=2
rho=7.85 #Dichte von Stahl in kg/dm^3
#Berechnungen durchführen
def calc():
    l=sldL.value #Länge in dm
    d=sldD.value #Durchmesser in dm
    r=d/2.0
    zylinder.length = l
    zylinder.radius = r
    V=pi*r**2*l #Volumen
    m=rho*V     #Masse
    J=m*r**2/2*1e-2  #Trägheitsmoment
    txtL.text=text='\t %2.1f dm' %l
    txtD.text=text='\t %2.1f dm' %d
    lblV.text = '<i>V</i> = %2.1f dm<sup>3</sup>' %V
    lblM.text = '<i>m</i> = %2.1f kg' %m
    lblJ.text = '<i>J</i> = %2.1f kgm<sup>2</sup>' %J 
#Grafikbereich
scene.title="<h3>Trägheitsmoment eines Zylinders</h3>"
scene.background = color.white
scene.range=5
#Zyliderobjekt erzeugen
zylinder = cylinder(pos=vec(-5,0,0),color=color.red)
zylinder.axis=vec(l0,0,0)
zylinder.radius=d0/2
#Slider: Länge ändern
scene.caption = "\nLänge ändern: \n\n" 
sldL = slider(bind=calc,min=1,max=10,value=l0,length=650)
txtL = wtext(text='\t %2.1f dm' %sldL.value)
#Slider: Durchmesser ändern
scene.append_to_caption("\n\nDurchmesser ändern: \n\n")
sldD = slider(bind=calc,min=1,max=4,value=d0,length=650)
txtD = wtext(text='\t %2.0f dm' %sldD.value)
scene.append_to_caption("\n\n")
#Ergebnisse ausgeben
lblV = label(pos=vec(-4,-4,0),text='<i>V</i> = %2.1f dm<sup>3</sup>' %0)
lblM = label(pos=vec(0,-4,0),text='<i>m</i> = %2.1f kg' %0)
lblJ = label(pos=vec(4,-4,0),text='<i>J</i> = %2.1f kgm<sup>2</sup>' %0)
