#abb_09_07.py
'''Überlagerung Schwingungen'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
tmax=10
A=10     #Amplitude
w10=2
w20=2
phi= np.pi #Phasenkonstante
#1. Schwingung
def f1(t,w1):
    return A*np.cos(w1*t)
#2. Schwingung
def f2(t,w2,phi):
    return A*np.cos(w2*t-phi)
#Summe
def f3(t,w1,w2,phi):
    return f1(t,w1)+f2(t,w2,phi)
#Grafikbereich
fig, ax = plt.subplots(3,figsize=(10,10),label='Überlagerung von Schwingungen')
#Wertebereiche für x- und y-Achse
ax[0].axis([0,tmax,-12,12])
ax[1].axis([0,tmax,-12,12])
ax[2].axis([0,tmax,-22,22])
ax[0].set_xticks([]);ax[1].set_xticks([])
#
t=np.linspace(0,20,500)
ax[0].plot(t,f1(t,w10),'b-',lw=1.5)
ax[1].plot(t,f2(t,w20,phi),'r-',lw=1.5)
ax[2].plot(t,f3(t,w10,w20,phi),'k-',lw=1.5) 
#Beschriftungen
ax[0].set_ylabel('$y_{1}$')
ax[1].set_title(r'$\varphi$ = %2.2f °' %np.degrees(phi))
ax[1].set_ylabel('$y_{2}$')
ax[2].set_ylabel('$y_{1} + y_{2}$')
ax[2].set_xlabel('$t$')

plt.show()



'''
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF007.svg")
fig.savefig("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF007.pdf")
'''
