#L_09_01.py
'''
Ausgabe der Kennwerte
Darstellung der Bewegungs- und Spannenergie als Funktionsplot
'''
from sympy import *
from sympy.plotting import plot, PlotGrid
t = symbols('t')
x = Function('x')(t)
m=1   #Masse in kg
b=0   #Dämpfungskonstante in kg/s
k=1   #Federkonstante in N/m
#Kennwerte
delta=b/(2*m)           #Abklingkonstante 1/s
w0=sqrt(k/m)            #Eigenkreisfrequenz 1/s
wd =sqrt(w0**2-delta**2)#Kreisfrequenz der gedämpften Schwingung 1/s
T=2.0*pi/wd             #Periodendauer s
dgl=Eq(x.diff(t,2) + b/m*x.diff(t,1) + k/m*x,0) #DGL 2. Ordnung
#Anfangswerte
aw={
    x.subs(t,0):5,           #Auslenkung
    x.diff(t,1).subs(t,0):0  #Anfangsgeschwindigkeit
    }
#Lösung der DGL
aL=dsolve(dgl)                 #allgemeine Lösung der DGL
sL=dsolve(dgl,ics=aw).evalf(3) #spezielle Lösung der DGL
x_t = sL.rhs.evalf(3)          #rechte Seite der Funktion
v_t = diff(x_t,t,1).evalf(3)   #Geschwindigkeit, 1. Ableitung
a_t = diff(x_t,t,2).evalf(3)   #Beschleunigung,  2. Ableitung
Ekin=1/2*m*v_t**2
Espan=1/2*k*x_t**2
#Ausgaben
print("Abklingkonstante \u03B4 = %2.2f 1/s" %delta)
print("Eigenkreisfrequenz \u03C90 = %2.3f 1/s" %w0)
print("Kreisfrequenz \u03C9d = %2.3f 1/s" %wd)
print("Periodendauer T = %2.2f s" %T)
print("Frequenz f = %2.2f Hz" %(1/T))
print("allgemeine Lösung\n",aL)
print("spezielle Lösung\n",sL)
print("Auslenkung\nx(t) =",x_t)
print("Geschwindigkeit\nv(t) =",v_t)
print("Beschleunigung\na(t) =",a_t)
#Funktionsplots
p1=plot(x_t,(t,0,20),ylabel='Auslenkung',line_color='blue',show=False)
p2=plot(v_t,(t,0,20),ylabel='Geschwindigkeit',line_color='green',show=False)
p3=plot(a_t,(t,0,20),ylabel='Beschleunigung',line_color='red',show=False)
p4=plot(Ekin,(t,0,20),ylabel='kin. Energie',line_color='red',show=False)
p5=plot(Espan,(t,0,20),ylabel='Spannenergie',line_color='red',show=False)
p = PlotGrid(5, 1, p1, p2, p3,p4,p5,size=(8,8))

# p.save("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF002.svg")
# p.save("/Users/veit/documents/Python_Mechanik/Bilder/48223_09-NF002.pdf")


