#L_09_04.py
'''
Physikalisches Pendel
Sinuskurve zeichnen
'''
import numpy as np
import matplotlib.pyplot as plt
from scipy.integrate import solve_ivp
#Daten
f=1   #Frequenz in 1/s
#Auslenkung in °
phi0=60 #Vergrößern Sie hier schrittweise die Auslenkung und beobachten Sie die Abweichung von der Sinusform 
#DGL-System
def dgl(t,a0,w02):
    phi,w = a0
    dphi_dt = w 
    dw_dt =  -w02*np.sin(phi) 
    return dphi_dt,dw_dt
#
T=1/f
w02=(2*np.pi*f)**2 #Quadrat der Kreisfrequenz
#Lösung der DGL
t = np.linspace(0,2*T,500)
z=solve_ivp(dgl,[0,2*T],[np.radians(phi0),0],args=(w02,),dense_output=True)
phi, w = z.sol(t)
#Funktion für Hüllkurve
A=np.max(w) #Amplitude ermitteln
huellkurve=lambda t:-A*np.sin(2*np.pi*f*t) 
#Grafikbereich
fig,ax = plt.subplots(2,1,figsize=(12,8),label='Feder-Masse-Schwinger')
ax[0].plot(t,np.degrees(phi),'r-',lw=1.5)  #Auslenkung
ax[1].plot(t,w,'b-',lw=1.5)     #Winkelgeschwindigkeit
ax[1].plot(t,huellkurve(t),'k--',lw=1.0) #Vergleich mit Sinusfunktion
#Beschriftungen
ax[0].set(ylabel=r'$\varphi$ in °',title='Auslenkung')
ax[1].set(xlabel='$t$ in s',ylabel=r'$\omega$ in rad/s')
ax[1].set_title("$f$ = %2.2f Hz" %f)
fig.tight_layout()
plt.show()

