#L_09_06.py
#Animation physikalisches Pendel
#Ausgabe der Energien
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
from scipy.integrate import solve_ivp
#Daten
phi0 = 90  #Auslenkung in °
l = 1.5    #Länge der Stange in m
ds = 0.05  #Durchmesser der Stange in m
dk = 0.2   #Durchmesser der Kugel in m
dt=0.01    #Zeitschrittweite
g=9.81     #Erdbeschleunigung m/s^2
#Funktionsdefinition für Trägheitsmoment
def pendel(l,ds,dk):
    R=dk/2
    rho=7850  #Dichte von Stahl kg/m^3
    ms=rho*np.pi*(ds/2)**2*l #Masse der Stange
    mk=rho*4/3*np.pi*R**3    #Masse der Kugel
    m=ms+mk #Gesamtmasse
    ls=l*(0.5*ms+mk)/(ms+mk)
    J=mk*l**2*(1+2/5*R**2/l**2+1/3*ms/mk)
    return m,ls,J
#DGL-System
def dgl(t,a0,w02):
    phi,w = a0
    dphi_dt = w
    dw_dt =  -w02*np.sin(phi) 
    return dphi_dt,dw_dt
#Quadrat der Kreisfrequenz berechnen
m,ls,J = pendel(l,ds,dk)
w02=m*g*ls/J  #Quadrat der Kreisfrequenz
T=2*np.pi/np.sqrt(w02) #Schwingungsdauer
#Lösung der DGL
t = np.arange(0,2*T,dt)
z=solve_ivp(dgl,[0,2*T],[np.radians(phi0),0],args=(w02,),dense_output=True)
phi, w = z.sol(t)
#leeres Array für x, y-Koordinaten
x,y = np.empty(t.size),np.empty(t.size)
#Koordinatendaten für Animationsfunktion ermitteln
def update(i):
    h=ls*(1-np.cos(phi[i])) #Höhe
    Epot = m*g*h #potentielle Energie
    Ekin=0.5*J*w[i]**2
    Eges=Epot+Ekin
    txtEpot.set_text('$E_{pot}$ = %2.1f J' %Epot)
    txtEkin.set_text('$E_{kin}$ = %2.1f J' %Ekin)
    txtEges.set_text('$E_{ges}$ = %2.1f J' %Eges)
    #print(Epot,Ekin,Eges)
    x,y = l*np.sin(phi),-l*np.cos(phi) #x,y-Koordinaten
    stange.set_data([0,x[i]],[0,y[i]])
    kugel.set_data([x[i]],[y[i]])
    return stange,kugel,txtEpot,txtEkin,txtEges
#Grafikbereich
fig,ax= plt.subplots(figsize=(8, 8))
SIZE=14
txtEpot=ax.text(-l,l,'',fontsize=SIZE)
txtEkin=ax.text(-l,0.85*l,'',fontsize=SIZE)
txtEges=ax.text(-l,0.7*l,'',fontsize=SIZE)
breite=1.15*l
ax.axis([-breite,breite,-breite,breite])
ax.set_aspect('equal')
ax.plot(0,0,'bo', markersize='15')    #Lager
stange, = ax.plot([],[], 'b-', lw=10) #Stange
kugel, =  ax.plot([],[], 'ro', markersize='30') #Kugel
ani=FuncAnimation(fig, update,frames=t.size,interval=20,blit=True)
#Beschriftung
ax.set(xlabel='$x$',ylabel='$y$')
ax.set_title('Trägheitsmoment $J = %3.2f \,\mathrm{kgm^2}$'%J)
plt.show()



'''

fig.savefig('04_038.png')
fig.savefig('04_038.svg')
'''

