#L_09_07.py
'''Überlagerung Schwingungen'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
tmax=10
A=10     #Amplitude
w10=9
w20=10
#1. Schwingung
def f1(t,w1):
    return A*np.cos(w1*t)
#2. Schwingung
def f2(t,w2,phi):
    return A*np.cos(w2*t-phi)
#Summe
def f3(t,w1,w2,phi):
    return f1(t,w1)+f2(t,w2,phi)
#Änderungen abfragen
def update(val):
    w1=sldW1.val
    w2=sldW2.val
    phi=sldPhi.val
    phi=np.deg2rad(phi)
    kurve1.set_data(t,f1(t,w1))
    kurve2.set_data(t,f2(t,w2,phi))
    kurve3.set_data(t,f3(t,w1,w2,phi))
#Grafikbereich
fig, ax = plt.subplots(3,figsize=(10,10),label='Überlagerung von Schwingungen')
fig.subplots_adjust(left=0.14,bottom=0.2,top=0.95)
#Wertebereiche für x- und y-Achse
ax[0].axis([0,tmax,-12,12])
ax[1].axis([0,tmax,-12,12])
ax[2].axis([0,tmax,-22,22])
ax[0].set_xticks([]);ax[1].set_xticks([])
#
t=np.linspace(0,20,500)
kurve1, = ax[0].plot(t,f1(t,w10),'b-',lw=1)
kurve2, = ax[1].plot(t,f2(t,w20,0),'r-',lw=1)
kurve3, = ax[2].plot(t,f3(t,w10,w20,0),'g-',lw=1) 
#x-, y-Position, Laenge, Hoehe
xyW1 = fig.add_axes([0.1, 0.09, 0.8, 0.03])
xyW2 = fig.add_axes([0.1, 0.05, 0.8, 0.03])
xyPhi = fig.add_axes([0.1,0.01, 0.8, 0.03])
#Slider Objekte erzeugen
sldW1=Slider(xyW1,r'$\omega_{1}$',5,10, valinit=w10,valstep=0.1)#f1
sldW2=Slider(xyW2,r'$\omega_{2}$',5,10, valinit=w20,valstep=0.1)#f2
sldPhi=Slider(xyPhi,r'$\varphi$',0,180, valinit=0,valstep=1)#Phasenverschiebung
#Änderungen durchfuehren
sldW1.on_changed(update)
sldW2.on_changed(update)
sldPhi.on_changed(update)
#Beschriftungen
ax[0].set_ylabel('$y_{1}$')
ax[1].set_ylabel('$y_{2}$')
ax[2].set_ylabel('$y_{1} + y_{2}$')
ax[2].set_xlabel('$t$')
plt.show()




