#!/usr/bin/env python3
#vp_federpendel.py
from vpython import *
#Daten
kf=1.0      #Federkonstante N/m
m=1.0       #Masse des Wuerfels in kg
w02 = kf/m  #Quadrat der Kreisfrequenz
x = 3       #Anfangswert der Auslenkung
v = 0       #Anfangsgeschwindigkeit
x0 = 5      
cb = color.gray(0.8) #Farbe der Unterlage
dt=2e-2     #Zeitschrittweite
t=0
#Boolesche Variable
run = True
#Entscheidung für Stop oder Start
def startStop(e):
    global run
    run = not run
    if run:
        e.text = "Stop"
    else:
        e.text = "Start"
#Grafikbereich
scene.width=600
scene.height=400
scene.center=vector(0,0,0) #x,y,z
scene.background = color.white
scene.userzoom = False    #kein Zoom
scene.userspin = False 
#Feder
feder=helix(radius=0.4,color=color.yellow)
feder.pos=vector(-x0,0.1,0)
feder.axis=vector(0,0,0)
feder.thickness=0.1
feder.coils=8
#Wand links: x0,y0,z0,Laenge, Hoehe, Tiefe
box(pos=vec(-x0,0.2,0),size=vec(0.2,1.8,2),color=cb)
#Boden
box(pos=vec(0,-0.6,0),size=vec(10,0.2,2),color=cb)
#Masse
masse=box(size=vec(1.4,1.4,1.4),color=color.red)
masse.pos=feder.pos
#Label für Ausgaben
lblT=label(pos=vec(-4,-2.0,0),text='t  = %2.2f s' %0)
lblX=label(pos=vec(-4,-2.6,0),text='x  = %2.2f ' %0)
lblV=label(pos=vec(-4,-3.2,0),text='v  = %2.2f ' %0)
lblEspan=label(pos=vec(4,-2,0),text='Es  = %1.2f J' %0)
lblEkin=label(pos =vec(4,-2.6,0),text='Ek  = %1.2f J' %0)
lblEges=label(pos =vec(4,-3.2,0),text='Eg  = %1.2f J' %0)
#Beschriftung fuer Slider
scene.caption = "D&auml;mpfung &auml;ndern: \n\n"
#Daempfung ermitteln
def daempfung(s):
    txtB.text = '%1.2f'%s.value
#Slider fuer Daempfung 
sldB=slider(bind=daempfung,min=0,max=0.5,length=550)
#Textfeld für Ausgabe der Dämpfung
txtB = wtext(text='%1.2f' %sldB.value)
#Einheit der Daempfungskonstante
scene.append_to_caption(' kg/s\n\n')
#Start-Stop-Button
button(bind=startStop,text="Stop",pos=scene.caption_anchor)
#Animationsschleife
while True:
    rate(100)
    b=sldB.value #Wert fuer Daempfungskonstante kg/s
    if run:
        #Loesung der DGL mit dem Euler-Verfahren
        x = x + v*dt                 #Weg
        v = v - w02*x*dt - b/m*v*dt  #Geschwindigkeit
        #Energien berechnen
        Espan=0.5*kf*x**2 #Spannenergie
        Ekin=0.5*m*v**2   #kinetische Energie
        Eges = Ekin + Espan
        #Feder-Masse-System darstellen
        feder.axis= vector(x + x0,0,0) #Feder
        masse.pos = vector(x,0,0)      #Masse
        t+=dt
        #Ausgabe der aktuellen Energien
        lblT.text= '<i>t</i> = %2.2f s' %t
        lblX.text= '<i>x</i> = %1.2f  ' %x
        lblV.text= '<i>v</i> = %1.2f m/s ' %v
        lblEspan.text= '<i>E</i><sub>span</sub> = %1.2f J' %Espan
        lblEkin.text = '<i>E</i><sub>kin</sub> = %1.2f J' %Ekin
        lblEges.text = '<i>E</i><sub>ges</sub> = %1.2f J' %Eges
    else:
        v=0  #neuer Anfangswert für Geschwindigkeit
        x=3  #neue Auslenkung
        t=0  #Zeit zuruecksetzen