#ani_ueberlagerung.py
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
f1 = 100     #Frequenz in Hz
f2 = 400     #Frequenz in Hz
phi= 0       #Phasenverschiebung
v = 343      #Ausbreitungsgeschwindigkeit in m/s
dt=5e-5      #Zeitschrittweite in s
xmax,smax=10,3
#Berechnungen
phi=np.radians(phi)
lamda1 = v/f1     #Wellenlänge in m
lamda2 = v/f2     #Wellenlange in m 
k1=2*np.pi/lamda1 #Wellenzahl
k2=2*np.pi/lamda2 #Wellenzahl
w1=2*np.pi*f1     #Kreisfrequenz
w2=2*np.pi*f2     #Kreisfrequenz
#Aktualisierung der Funktionswerte
def ueberlagerung(i):
    t=i*dt
    s1=smax*np.sin(w1*t - k1*x)
    s2=smax*np.sin(w2*t - k2*x + phi)
    s3=s1+s2
    linie1.set_data(x,s1)
    linie2.set_data(x,s2)
    linie3.set_data(x,s3) 
    return linie1,linie2,linie3
#Grafikbereich
fig, ax = plt.subplots(3,1,figsize=(9,6))
x = np.linspace(0,xmax,500)
ax[0].axis([0,xmax,-1.2*smax,1.2*smax])
ax[1].axis([0,xmax,-1.2*smax,1.2*smax])
ax[2].axis([0,xmax,-2.4*smax,2.4*smax])
linie1, = ax[0].plot([],[],'b-')
linie2, = ax[1].plot([],[],'g-')
linie3, = ax[2].plot([],[],'r-')
ani = FuncAnimation(fig,ueberlagerung,interval=10,blit=True,save_count=500)
#Beschriftungen
ax[0].set_title(r'$f_{1}$ = %2.1f Hz,  $\lambda_{1}$ = %2.2f m' %(f1,lamda1))
ax[1].set_title(r'$f_{2}$ = %2.1f Hz,  $\lambda_{2}$ = %2.2f m' %(f2,lamda2))
ax[2].set_title('Überlagerung')
ax[0].set_ylabel('$s_{1}$')
ax[1].set_ylabel('$s_{2}$')
ax[2].set_ylabel('$s_{1} + s_{2}$')
ax[2].set_xlabel('$x$ in m')
fig.tight_layout()
plt.show()



