#L_10_02.py
'''
Zeitbild einer Welle
Ort x als Parameter
'''
import numpy as np
import matplotlib.pyplot as plt
f = 1 #Hz
T=1/f
w=2*np.pi*f
k = 1
#Funktionsdefinition für Transversalwelle
def welle(t,x):
    return np.sin(w*t - k*x)
#Grafikbereich
fig, ax =plt.subplots(figsize=(8,6),label='Zeitbild einer Welle in Abhängigkeit vom Ort')
t = np.linspace(0,T,200)
xi=[0,np.pi/6,2*np.pi/6,3*np.pi/6]
for i in xi:
    ax.plot(t,welle(t,i),label='$kx$ = %2.3f ' %i)
ax.set(xlabel='$t$', ylabel='Auslenkung')
ax.legend()
plt.show()