#L_10_05a.py
'''
Wellenausbreitung
Auslenkungsgeschwindigkeit mit dem zentralen Differenzenquotienten berechnen
'''
import numpy as np
import matplotlib.pyplot as plt
#Daten
ymax=0.5 #Amplitude
f=1   #Frequenz in Hz
v=1   #Ausbreitungsgeschwindigkeit in m/s
#Berechnungen
w =  2*np.pi*f    #Kreisfrequenz
T =  1/f          #Periodendauer
lam=f/v           #Wellenlänge
k=2*np.pi/lam     #Kreiswellenzahl
#zentraler Differenzenquotient
def diff(f,t,h=1e-3):
    return (f(t+h)-f(t-h))/(2*h)
#Funktionsdefinition
def y(t,x=lam/2):
    return ymax*np.cos(w*t - k*x)
#Auslenkungsgeschwindigkeit
def u(t,x=lam/2):
    return diff(y,t)
#zwei Unterdiagramme untereinander
fig, ax = plt.subplots(2,1,figsize=(10,10))
t = np.linspace(0, T, 500) #Zeitbereich
x = np.linspace(0,lam,500) #Ausdehnung der Welle
#Welle
ax[0].plot(x,y(t),'b-',lw=1.5)
#Auslenkungsgeschwindigkeit
ax[1].plot(x,u(t),'r-',lw=1.5)
#Beschriftungen
ax[0].set_title('Wellenausbreitung')
ax[0].set_xlabel('$t$ in s')
ax[0].set_ylabel('$y$ in m')
ax[1].set_title('Auslenkungsgeschwindigkeit')
ax[1].set_xlabel('$t$ in s')
ax[1].set_ylabel('$u$ in m/s')
fig.tight_layout()
plt.show()




