#L_10_05b.py
'''
Wellenausbreitung
Auslenkungsgeschwindigkeit mit Nummdifftools berechnen
'''
import numpy as np
import matplotlib.pyplot as plt
from numdifftools import Derivative
#Daten
ymax=0.5 #Amplitude
f=1   #Frequenz in Hz
v=1   #Ausbreitungsgeschwindigkeit in m/s
#Berechnungen
w =  2*np.pi*f    #Kreisfrequenz
T =  1/f          #Periodendauer
lam=f/v           #Wellenlänge
k=2*np.pi/lam     #Kreiswellenzahl
#Funktionsdefinition
def y(t,x=lam/2):
    return ymax*np.cos(w*t - k*x)
#Auslenkungsgeschwindigkeit
def u(t):
    df=Derivative(y,n=1)
    return df(t)
#Grafikbereich
fig, ax = plt.subplots(2,1,figsize=(10,10))
t = np.linspace(0, T, 500) #Zeitbereich
x = np.linspace(0,lam,500) #Ausdehnung der Welle
#Welle
ax[0].plot(x,y(t),'b-',lw=1.5)
#Auslenkungsgeschwindigkeit
ax[1].plot(x,u(t),'r-',lw=1.5)
#Beschriftungen
ax[0].set_title('Wellenausbreitung')
ax[0].set_xlabel('$t$ in s')
ax[0].set_ylabel('$y$ in m')
ax[1].set_title('Auslenkungsgeschwindigkeit')
ax[1].set_xlabel('$t$ in s')
ax[1].set_ylabel('$u$ in m/s')
fig.tight_layout()
plt.show()




