#L_10_06.py
'''
Optimierung der Animation einer Longitudinalwelle
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.animation import FuncAnimation
#Daten
N = 45
L = 20       #Abstand zwischen Sender und Empfänger in m
smax = 10e-6 #maximale Auslenkung der Schallwelle in m
f = 50       #Frequenz in Hz
v = 343      #Ausbreitungsgeschwindigkeit der Welle in m/s
dt = 5e-4    #Zeitschrittweite
rho=1.21     #Luftdichte in kg/m^3
lamda=v/f    #Wellenlänge in m
w = 2*np.pi*f      #Kreisfrequenz
k = 2*np.pi/lamda  #Wellenzahl
pmax=rho*v*w*smax  #maximaler Schalldruck in Pa
#Aktualisierung der Funktionswerte
def longitudinalwelle(i):
    t = i*dt
    s = smax*np.cos(k*x1 - w*t)*5e4 #Auslenkung der Moleküle
    p = pmax*np.sin(k*x2 - w*t)     #Schalldruck in Pa
    m1.set_data(x1 + s,0*s + 0.25)
    m2.set_data(x1 + s,0*s)
    m3.set_data(x1 + s,0*s - 0.25)
    mm.set_data([x1[N//2]]+s[N//2],0*s) #Markierung in der Mitte
    linie.set_data(x2,p) #Schalldruck darstellen
    return m1,m2,m3,linie,mm
#Grafikbereich
fig, ax = plt.subplots(2,1,figsize=(12, 4))
x1 = np.linspace(0,L,N)
x2 = np.linspace(0,L,500)
ax[0].axis([0,L,-1,1])
ax[1].axis([0,L,-1.2*pmax,1.2*pmax])
m1,m2,m3 = ax[0].plot([],[],'bo',[],[],'bo',[],[],'bo')
mm, = ax[0].plot([],[],'ro')
linie, = ax[1].plot([],[],'r-')
ani = FuncAnimation(fig,longitudinalwelle,interval=30,blit=True,save_count=500)
#Beschriftungen
ax[0].tick_params(left=False,labelleft=False)
ax[0].set_title(r'$\lambda$ = %2.1f m' %lamda)
ax[1].set_title('Schalldruck')
ax[1].set_xlabel('$x$ in m')
ax[1].set_ylabel('$p$ in Pa')
fig.tight_layout()
plt.show()

#print(28/(1.21*2*np.pi*50*343))