#L_10_07.py
'''
Veranschaulichung der Hörschwelle
'''
import numpy as np
import matplotlib.pyplot as plt
Pmax = 28
rho=1.21
v=343
#maximale Amplitude als Funktion der Frequenz
def smax(f):
    return Pmax/(rho*2*np.pi*v*f)
#Grafikbereich
fig,ax = plt.subplots()
f=np.arange(50,10000,1)
ax.semilogx(f,smax(f)*1e6) #Umwandlung in µm
#Beschriftungen
ax.set_xlabel('$f$ in Hz')
ax.set_ylabel('Auslenkung in µm')
plt.show()