#L_10_08.py
'''
Simulation der Überlagerung von zwei Wellen mit einem Slider
'''
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Slider
#Daten
f=100 #Frequenz in Hz
A=5
v=343       #m/s
lamda=v/f   #Wellenlänge
k=2*np.pi/lamda
xmax=10
#Funktionsdefinitionen
def welle(x,phi):
    t=0
    return A*np.sin(2*np.pi*f*t + k*x - phi)
#Änderungen abfragen
def update(val):
    phi = sldPhi.val
    s1=welle(x,phi) 
    s2=welle(x,-phi)
    s3=s1+s2
    kurve1.set_data(x,s1)
    kurve2.set_data(x,s2)
    kurve3.set_data(x,s3)
#Grafikbereich
fig,ax=plt.subplots(label='Überlagerung von Wellen')
ax.axis([0, xmax, -2.2*A, 2.2*A])
fig.subplots_adjust(left=0.12,bottom=0.25)
x=np.linspace(0,xmax,200)
kurve1, = ax.plot(x,welle(x,-np.pi),'b-',lw=1)
kurve2, = ax.plot(x,welle(x,np.pi),'g-',lw=1)
kurve3, = ax.plot(x,welle(x,0),'r-',lw=2)
#Objekte für Steuerelemente platzieren
#linker Rand, unterer Rand, Breite, Höhe
xyPhi =fig.add_axes([0.05, 0.1, 0.83, 0.03])
#Objekt für Steuerelemente erzeugen
sldPhi=Slider(xyPhi,r'$\varphi$',-np.pi,np.pi,valinit=0,valstep=0.01)
#Ereignisverarbeitung
sldPhi.on_changed(update)
#Beschriftungen
ax.set_title(r'$\lambda$ = %2.3f m, $k$ = %2.3f 1/m' %(lamda,k))
ax.set_xlabel('$x$')
ax.set_ylabel('Auslenkung')
plt.show()


